/**
* \file: BaiduCoreCallbackDealer.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <bdcl/AditVideoSink.h>
#include <bdcl/AditAudioSink.h>
#include <bdcl/AditAudioSource.h>
#include <bdcl/CCarLifeLib.h>
#include "BaiduCoreCallbackDealer.h"

LOG_IMPORT_CONTEXT(bdcl_init)

namespace adit { namespace bdcl {

IAditAudioSinkCallbacks* CoreCallbackDealer::mMediaAudioCallbacks = nullptr;
IAudioSinkBackendCallbacks* CoreCallbackDealer::mMediaAudioBackendCallbacks = nullptr;

IAditAudioSinkCallbacks* CoreCallbackDealer::mNaviTtsAudioCallbacks = nullptr;
IAudioSinkBackendCallbacks* CoreCallbackDealer::mNaviTtsAudioBackendCallbacks = nullptr;

IAditAudioSinkCallbacks* CoreCallbackDealer::mVrTtsAudioCallbacks = nullptr;
IAudioSinkBackendCallbacks* CoreCallbackDealer::mVrTtsAudioBackendCallbacks = nullptr;

IAditAudioSourceCallbacks* CoreCallbackDealer::mVrCaptureAudioCallbacks = nullptr;

IAditVideoSinkCallbacks* CoreCallbackDealer::mVideoSinkCallbacks = nullptr;
IVideoSinkBackendCallbacks* CoreCallbackDealer::mVideoSinkBackendCallbacks = nullptr;

CoreCallbackDealer::CoreCallbackDealer() { }

CoreCallbackDealer::~CoreCallbackDealer() { }

void CoreCallbackDealer::registerMediaAudioCallbacks(IAditAudioSinkCallbacks* inCallbacks)
{
    if (inCallbacks == nullptr)
    {
        LOG_ERROR((bdcl_init, "Invalid media audio callbacks, can't be registered to Baidu core"));
        return;
    }
    mMediaAudioCallbacks = inCallbacks;

    CCarLifeLib::getInstance()->mediaRegisterInit(mediaInit);
    CCarLifeLib::getInstance()->mediaRegisterStop(mediaStop);
    CCarLifeLib::getInstance()->mediaRegisterPause(mediaPause);
    CCarLifeLib::getInstance()->mediaRegisterResume(mediaResume);
}

void CoreCallbackDealer::registerMediaAudioBackendCallbacks(IAudioSinkBackendCallbacks* inCallbacks)
{
    mMediaAudioBackendCallbacks = inCallbacks;

    CCarLifeLib::getInstance()->mediaRegisterNormalData(mediaNormalData);
}

void CoreCallbackDealer::registerNaviTtsAudioCallbacks(IAditAudioSinkCallbacks* inCallbacks)
{
    if (inCallbacks == nullptr)
    {
        LOG_ERROR((bdcl_init, "Invalid navigation TTS audio callbacks, can't be registered to Baidu core"));
        return;
    }
    mNaviTtsAudioCallbacks = inCallbacks;

    CCarLifeLib::getInstance()->ttsRegisterInit(ttsInit);
    CCarLifeLib::getInstance()->ttsRegisterStop(ttsStop);
}

void CoreCallbackDealer::registerNaviTtsAudioBackendCallbacks(IAudioSinkBackendCallbacks* inCallbacks)
{
    mNaviTtsAudioBackendCallbacks = inCallbacks;

    CCarLifeLib::getInstance()->ttsRegisterNormalData(ttsNormalData);
}

void CoreCallbackDealer::registerVrTtsAudioCallbacks(IAditAudioSinkCallbacks* inCallbacks)
{
    if (inCallbacks == nullptr)
    {
        LOG_ERROR((bdcl_init, "Invalid VR TTS audio callbacks, can't be registered to Baidu core"));
        return;
    }
    mVrTtsAudioCallbacks = inCallbacks;

    CCarLifeLib::getInstance()->vrRegisterInit(vrInit);
    CCarLifeLib::getInstance()->vrRegisterStop(vrStop);
}

void CoreCallbackDealer::registerVrTtsAudioBackendCallbacks(IAudioSinkBackendCallbacks* inCallbacks)
{
    mVrTtsAudioBackendCallbacks = inCallbacks;

    CCarLifeLib::getInstance()->vrRegisterNormalData(vrNormalData);
    CCarLifeLib::getInstance()->vrRegisterInterrupt(vrInterrupt);

}

void CoreCallbackDealer::registerVrCaptureAudioCallbacks(IAditAudioSourceCallbacks* inCallbacks)
{
    if (inCallbacks == nullptr)
    {
        LOG_ERROR((bdcl_init, "Invalid VR capture audio callbacks, can't be registered to Baidu core"));
        return;
    }
    mVrCaptureAudioCallbacks = inCallbacks;

    CCarLifeLib::getInstance()->cmdRegisterMicRecordWakeupStart(cmdMicRecordWakeupStart);
    CCarLifeLib::getInstance()->cmdRegisterMicRecordEnd(cmdMicRecordEnd);
    CCarLifeLib::getInstance()->cmdRegisterMicRecordRecogStart(cmdMicRecordRecogStart);
}

void CoreCallbackDealer::registerVideoSinkCallbacks(IAditVideoSinkCallbacks* inCallbacks)
{
    if (inCallbacks == nullptr)
    {
        LOG_ERROR((bdcl_init, "Invalid video sink callbacks, can't be registered to Baidu core"));
        return;
    }
    mVideoSinkCallbacks = inCallbacks;
    CCarLifeLib::getInstance()->cmdRegisterVideoEncoderInitDone(cmdVideoEncoderInitDone);
    CCarLifeLib::getInstance()->cmdRegisterConnectException(cmdRegisterConnectException);

}
void CoreCallbackDealer::registerVideoSinkBackendCallbacks(IVideoSinkBackendCallbacks* inCallbacks)
{

    mVideoSinkBackendCallbacks = inCallbacks;
    CCarLifeLib::getInstance()->videoRegisterDataReceive(videoDataReceive);

}

/* Media audio sink callbacks initiated by Baidu core */
void CoreCallbackDealer::mediaInit(S_AUDIO_INIT_PARAMETER *initParam)
{
    LOGD_DEBUG((bdcl_init,"mediaInit() is invoked sampleRate= %d, channelConfig= %d, sampleFormat= %d",
            initParam->sampleRate, initParam->channelConfig, initParam->sampleFormat));
    mMediaAudioCallbacks->onPlaybackInit(initParam->sampleRate, initParam->channelConfig, initParam->sampleFormat);
}

void CoreCallbackDealer::mediaNormalData(u8 *data, u32 len)
{
    mMediaAudioBackendCallbacks->onAudioDataAvailable(data, len);
}

void CoreCallbackDealer::mediaStop()
{
    mMediaAudioCallbacks->onPlaybackStop();
}

void CoreCallbackDealer::mediaPause()
{
    mMediaAudioCallbacks->onPlaybackPause();
}

void CoreCallbackDealer::mediaResume()
{
    mMediaAudioCallbacks->onPlaybackResume();
}

/* Navigation text-to-speech audio sink callbacks initiated by Baidu core */
void CoreCallbackDealer::ttsInit(S_AUDIO_INIT_PARAMETER *initParam)
{
    LOGD_DEBUG((bdcl_init,"ttsInit() is invoked sampleRate= %d, channelConfig= %d, sampleFormat= %d",
            initParam->sampleRate, initParam->channelConfig, initParam->sampleFormat));
    mNaviTtsAudioCallbacks->onPlaybackInit(initParam->sampleRate, initParam->channelConfig, initParam->sampleFormat);
}

void CoreCallbackDealer::ttsNormalData(u8 *data, u32 len)
{
    mNaviTtsAudioBackendCallbacks->onAudioDataAvailable(data, len);
}

void CoreCallbackDealer::ttsStop()
{
    mNaviTtsAudioCallbacks->onPlaybackStop();
}

/* Voice recognition text-to-speech audio sink callbacks initiated by Baidu core */
void CoreCallbackDealer::vrInit(S_AUDIO_INIT_PARAMETER *initParam)
{
    LOGD_DEBUG((bdcl_init,"vrInit() is invoked sampleRate= %d, channelConfig= %d, sampleFormat= %d",
            initParam->sampleRate, initParam->channelConfig, initParam->sampleFormat));
    mVrTtsAudioCallbacks->onPlaybackInit(initParam->sampleRate, initParam->channelConfig, initParam->sampleFormat);
}

void CoreCallbackDealer::vrNormalData(u8 *data, u32 len)
{
    mVrTtsAudioBackendCallbacks->onAudioDataAvailable(data, len);
}

void CoreCallbackDealer::vrInterrupt()
{
    mVrTtsAudioBackendCallbacks->onPlaybackInterruptBackend();
}

void CoreCallbackDealer::vrStop()
{
    mVrTtsAudioCallbacks->onPlaybackStop();
}

void CoreCallbackDealer::cmdMicRecordWakeupStart()
{
    mVrCaptureAudioCallbacks->onMicRecordWakeupStart();
}

void CoreCallbackDealer::cmdMicRecordEnd()
{
    mVrCaptureAudioCallbacks->onMicRecordEnd();
}

void CoreCallbackDealer::cmdMicRecordRecogStart()
{
    mVrCaptureAudioCallbacks->onMicRecordRecognitionStart();
}

void CoreCallbackDealer::videoDataReceive(u8 *data, u32 len)
{
    mVideoSinkBackendCallbacks->onVideoDataAvailable(data, len);
}

void CoreCallbackDealer::cmdVideoEncoderInitDone(S_VIDEO_ENCODER_INIT_DONE* videoEncoderInitDone)
{
    LOGD_DEBUG((bdcl_init,"cmdVideoEncoderInitDone() is invoked Width= %d, Height= %d, FrameRate= %d",
            videoEncoderInitDone->width, videoEncoderInitDone->height, videoEncoderInitDone->frameRate));
    mVideoSinkCallbacks->onVideoEncoderInitDone(videoEncoderInitDone->width, videoEncoderInitDone->height,
            videoEncoderInitDone->frameRate);

}

void CoreCallbackDealer::cmdRegisterConnectException(S_CONNECTION_EXCEPTION* inException)
{
    LOGD_DEBUG((bdcl_init,"cmdRegisterConnectException() is invoked S_CONNECTION_EXCEPTION= %d", inException->exceptionType));
    mVideoSinkCallbacks->onConnectException(static_cast<carlifeConnectException> (inException->exceptionType));
}
} } /* namespace adit { namespace bdcl */
